/***************************************************************/
//
//
//		DirectX	[ particlecontrol.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 9/6
/*---------------------------------------------------------------
Update : 2016/9/6
			particlecontrol.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include <Windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "main.h"

#include "particle.h"
#include "emitter.h"

#include "game_equation.h"

// p[eBN̑ɕKv
#include "input.h"									// L[{[h
#include "mouse.h"

#include "game_equation.h"
#include "camera.h"

#include "tool_proc.h"
#include "resource.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))


/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define SET_SPEED ( 1.0f )															// Xs[hl

#define PARTICLE_MOVE    ( 10 )

// p[eBNRg[\
typedef struct{

	D3DXVECTOR3  center;
	D3DXVECTOR3  speed;
	D3DXVECTOR3  velocity;
	D3DXCOLOR    color;
	D3DXCOLOR    amountOfChangeInColor;
	float        radius;
	float        arc_base;
	float        arc_ref;
	int          life;

}PARTICLE_CONTROLER;


/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

void EmitterControl( const int index );


/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

PARTICLE_CONTROLER g_controler;									// p[eBNRg[[

EMITTER*  emitter;

int controlNumber = 0;


// CONTROLLEȐ
void InitController( void ) 
{

	// 0ԂEMITTEȐ
	SetEmitter( );

	// EMITTER̃AhX擾
	emitter = GetEmitter( );

}

// CONTROLLEȐI
void UninitController( void )
{


}

// CONTROLLER̍XV
void UpdateController( void )
{

	// EMITTER
	EmitterControl( controlNumber );

	if( GetKeyboardTrigger( DIK_SPACE ) ){
	
		SetEmitter( );
	}

	// EMIT PARTICLE
	for( int index = 0; index < 10; index++ ){
	
		if( emitter[ index ].use ){

			SetParticleEx( 
			&emitter[index].center,
			&emitter[index].speed,
			&emitter[index].velocity,
			&emitter[index].color,
			 emitter[index].radius,
			 emitter[index].theta,
			 emitter[index].theta_offset,
			 emitter[index].phy,
			 emitter[index].phy_offset,
			 emitter[index].life, 
			 emitter[index].textureIndex ); 
		}
	}

}

// COMTROLLER->EMITTER
void EmitterControl( const int index )
{

	// index -> 삷EMITTER̃CfbNXԍ

	// _Zbg
	if( GetKeyboardPress( DIK_LSHIFT ) && GetKeyboardTrigger( DIK_V ) ){
	
		// EMITTER̒S𒍎_ɐݒ
		SetLookAtView( &emitter[index].center );
	}

	// EMITTERړ
	if( GetMousePress( MOUSE_BUTTON_LEFT ) ){
		
		emitter[index].center.x -= GetMouseDefX( )*0.1f;
		emitter[index].center.y += GetMouseDefY( )*0.1f;
		EmitterUpdateFrag( true );
		UpdateDlgEdit( );
	}

	// EDIT EMITTERύX
	if( GetKeyboardTrigger( DIK_COMMA ) ){

		controlNumber--;
		controlNumber = LIMIT_MIM( controlNumber, 0 );
		EmitterUpdateFrag( true );

	}else if( GetKeyboardTrigger( DIK_PERIOD ) ){

		controlNumber++;
		controlNumber = LIMIT_MAX( controlNumber, EMITTER::EMITTER_MAX );
		EmitterUpdateFrag( true );
	}


	if( GetKeyboardPress( DIK_UP )){
		
		emitter[index].center.z -= PARTICLE_MOVE;
		EmitterUpdateFrag( true );
	}  
	if( GetKeyboardPress( DIK_DOWN )){
		
		emitter[index].center.z += PARTICLE_MOVE;
		EmitterUpdateFrag( true );
	}

	// ȁ
	if( GetKeyboardPress( DIK_Q )){
		
		g_controler.radius -= 2;
		g_controler.radius = LIMIT_MIM( g_controler.arc_ref, 1 );
		EmitterUpdateFrag( true );
	}
	if( GetKeyboardPress( DIK_A )){
		
		g_controler.radius += 2;
		EmitterUpdateFrag( true );
	}

	// F̏
	if( GetKeyboardPress( DIK_W	)){
		
		emitter[index].color.r -= 2;
		EmitterUpdateFrag( true );
	}
	if( GetKeyboardPress( DIK_S )){
		
		emitter[index].color.r += 2;
		EmitterUpdateFrag( true );
	}

	if( GetKeyboardPress( DIK_E	)){
		
		emitter[index].color.g -= 2;
		EmitterUpdateFrag( true );
	}
	if( GetKeyboardPress( DIK_D )){
		
		emitter[index].color.g += 2;
		EmitterUpdateFrag( true );
	}

	if( GetKeyboardPress( DIK_R	)){
		
		emitter[index].color.b -= 2;
		EmitterUpdateFrag( true );
	}
	if( GetKeyboardPress( DIK_F )){
		
		emitter[index].color.b += 2;
		EmitterUpdateFrag( true );
	}

	if( GetKeyboardPress( DIK_T ))	{
	
		g_controler.arc_ref += 1;
		g_controler.arc_ref = LIMIT_MAX( g_controler.arc_ref, 360 );
		EmitterUpdateFrag( true );
	}
	if( GetKeyboardPress( DIK_G ))	{
	
		g_controler.arc_ref -= 1;
		g_controler.arc_ref = LIMIT_MIM( g_controler.arc_ref, 1 );
		EmitterUpdateFrag( true );
	}

	if( GetKeyboardTrigger( DIK_O )){
	
		emitter[index].speed.x += 1;
		emitter[index].speed.y += 1;
		EmitterUpdateFrag( true );
	}
	if( GetKeyboardTrigger( DIK_L ) ){
	
		emitter[index].speed.x -= 1;
		emitter[index].speed.y -= 1;
		EmitterUpdateFrag( true );
	}

}

// ݕҏWEMITTER̔ԍ擾
int GetEmitterIndex( void )
{

	return controlNumber;

}

// ҏWԍ̕ύX
void SetEmitterIndex( const int index )
{

	controlNumber = index;
	controlNumber = LIMIT_MIM( controlNumber, 0 );
	controlNumber = LIMIT_MAX( controlNumber, EMITTER::EMITTER_MAX );

}

